<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resturant extends Model 
{

    protected $table = 'resturants';
    public $timestamps = true;

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function sliders()
    {
        return $this->hasMany('App\Models\Slider');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function favByUser()
    {
        return $this->belongsToMany('App\Models\User');
    }

    public function odrers()
    {
        return $this->hasMany('App\Models\Order');
    }

}